// shadowgen_nv.vsh

uniform mat4 vc0;	// worldViewProj
#ifdef TREE
uniform vec4 vc42;
uniform vec4 vc44;
uniform vec4 vc66;	// tree wind hack
#endif

void main()
{
#ifdef TREE
	// tree deformation
	vec4 r9;
    r9.x = gl_Vertex.x - vc66.y + vc42.w;
    r9.y = gl_Vertex.y;
    r9.z = gl_Vertex.z - vc66.z + vc44.w;
    r9.w = gl_Vertex.w;

    float r1x =  vc66.x * max(r9.x, r9.z);
	r1x *= 2.0;				// KLC -- Make tree swaying a little more obvious
    float r0y = sin(r1x);
	float r0x = cos(r1x);

	vec4 r5;
    r5.x = r0x;
    r5.y = 0.0;
    r5.z = -r0y;
    r5.w = vc66.y - vc42.w;

	vec4 r7;
    r7.x = r0y;
    r7.y = 0.0;
    r7.z = r0x;
    r7.w = vc66.z - vc44.w;

	vec4 r0;
    r0.x = dot(r9, r5);
    r0.y = gl_Vertex.y;
    r0.z = dot(r9, r7);
    r0.w = 1.0;

	// transform position
	vec4 r3 = r0 * vc0;
#else
	// transform position
	vec4 r3 = gl_Vertex * vc0;
#endif
	gl_Position = r3;
}
